<?php

declare(strict_types=1);

use Cake\Core\Configure;
use Cake\TestSuite\CakeTestSuiteDispatcher;
use Cake\Error\NotFoundException;

set_time_limit(0);
ini_set('display_errors', '1');

if (!defined('DS')) {
    define('DS', DIRECTORY_SEPARATOR);
}

if (!defined('ROOT')) {
    define('ROOT', dirname(__DIR__, 2));
}

if (!defined('APP_DIR')) {
    define('APP_DIR', basename(dirname(__DIR__)));
}

$vendorPath = ROOT . DS . APP_DIR . DS . 'Vendor' . DS . 'cakephp' . DS . 'cakephp' . DS . 'lib';
$dispatcher = 'Cake' . DS . 'Console' . DS . 'ShellDispatcher.php';

if (!defined('CAKE_CORE_INCLUDE_PATH') && file_exists($vendorPath . DS . $dispatcher)) {
    define('CAKE_CORE_INCLUDE_PATH', $vendorPath);
}

if (!defined('WEBROOT_DIR')) {
    define('WEBROOT_DIR', basename(__DIR__));
}

if (!defined('WWW_ROOT')) {
    define('WWW_ROOT', __DIR__ . DS);
}

if (!defined('CAKE_CORE_INCLUDE_PATH')) {
    ini_set('include_path', ROOT . DS . 'lib' . PATH_SEPARATOR . ini_get('include_path'));
    $failed = !include 'Cake' . DS . 'bootstrap.php';
} else {
    $failed = !include CAKE_CORE_INCLUDE_PATH . DS . 'Cake' . DS . 'bootstrap.php';
}

if (!empty($failed)) {
    trigger_error(
        "CakePHP core could not be found. Check the value of CAKE_CORE_INCLUDE_PATH in webroot/test.php.",
        E_USER_ERROR
    );
}

if (Configure::read('debug') < 1) {
    throw new NotFoundException(__('Debug setting does not allow access to this URL.'));
}

require dirname(__DIR__) . '/vendor/autoload.php';

CakeTestSuiteDispatcher::run();
