<?php
$cakeDescription = __d('cake_dev', 'CakePHP: the rapid development php framework');
$cakeVersion = __d('cake_dev', 'CakePHP %s', Configure::version());
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <?= $this->Html->charset() ?>
    <title><?= $cakeDescription ?>: <?= $this->fetch('title') ?></title>
    <?= $this->Html->meta('icon') ?>
    <?= $this->Html->css('cake.generic') ?>
    <?= $this->fetch('meta') ?>
    <?= $this->fetch('css') ?>
    <?= $this->fetch('script') ?>
</head>
<body>
    <div id="container">
        <div id="header">
            <h1><?= $this->Html->link($cakeDescription, 'http://cakephp.org') ?></h1>
        </div>
        <div id="content">
            <?= $this->Flash->render() ?>
            <?= $this->fetch('content') ?>
        </div>
        <div id="footer">
            <?= $this->Html->link(
                $this->Html->image('cake.power.gif', ['alt' => $cakeDescription, 'border' => '0']),
                'http://www.cakephp.org/',
                ['target' => '_blank', 'escape' => false, 'id' => 'cake-powered']
            ) ?>
            <p><?= $cakeVersion ?></p>
        </div>
    </div>
    <?= $this->element('sql_dump') ?>
</body>
</html>