<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class VideoCommentLikesTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('video_comment_like');
		$this->setPrimaryKey('id');

		$this->belongsTo('VideoComments', [
			'foreignKey' => 'comment_id',
		]);

		$this->belongsTo('Users', [
			'foreignKey' => 'user_id',
			'fields' => USER_FIELDS,
		]);

		// If you use contain(['Video.Sound', 'Video.User']) then define deep associations accordingly
		$this->hasOne('Videos', [
			'className' => 'Videos',
			'foreignKey' => false,
			'conditions' => ['Videos.id = VideoComments.video_id'],
			'bindingKey' => false,
			'joinType' => 'LEFT'
		]);
	}

	public function getDetails(int $id): ?array
	{
		return $this->find()
			->where(['VideoCommentLikes.id' => $id])
			->contain(['VideoComments.Videos', 'Users'])
			->enableHydration(false)
			->first();
	}

	public function getUserFavouriteComments(int $user_id): array
	{
		return $this->find()
			->where(['VideoCommentLikes.user_id' => $user_id])
			->contain(['VideoComments.Videos.Sounds', 'VideoComments.Videos.Users'])
			->enableHydration(false)
			->all()
			->toList();
	}

	public function ifExist(array $data): ?array
	{
		return $this->find()
			->where([
				'VideoCommentLikes.comment_id' => $data['comment_id'],
				'VideoCommentLikes.user_id' => $data['user_id'],
			])
			->contain(['VideoComments.Videos', 'Users'])
			->enableHydration(false)
			->first();
	}

	public function countLikes(int $comment_id): int
	{
		return $this->find()
			->where(['VideoCommentLikes.comment_id' => $comment_id])
			->count();
	}

	public function getAll(): array
	{
		return $this->find()
			->enableHydration(false)
			->all()
			->toList();
	}
}
