<?php

declare(strict_types=1);

namespace App\Model;

use Cake\ORM\Table;

class StripeCustomersTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('stripe_customers');
		$this->setPrimaryKey('id');
	}

	protected array $_schema = [
		'id' => ['type' => 'integer', 'length' => 12],
		'email' => ['type' => 'string'],
		'card' => ['type' => 'string'],
		'number' => ['type' => 'string'],
		'exp_month' => ['type' => 'string', 'length' => 2],
		'exp_year' => ['type' => 'string', 'length' => 4],
		'cvc' => ['type' => 'string'],
		'name' => ['type' => 'string'],
		'address_line_1' => ['type' => 'string'],
		'address_line_2' => ['type' => 'string'],
		'address_zip' => ['type' => 'string'],
		'address_state' => ['type' => 'string'],
		'address_country' => ['type' => 'string']
	];

	protected array $formatFields = [
		'card' => [
			'number',
			'exp_month',
			'exp_year',
			'cvc',
			'name',
			'address_line_1',
			'address_line_2',
			'address_zip',
			'address_state',
			'address_country'
		]
	];

	public function getCardDetails(string|int $stripeId): array
	{
		return $this->find()
			->where(['id' => $stripeId])
			->all()
			->toArray();
	}
}
