<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class ShopSlidersTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);
		$this->setTable('shop_slider');
		$this->setPrimaryKey('id');
	}

	public function getImages(): array
	{
		return $this->find()->toArray();
	}

	public function getDetails(int $id): array
	{
		$result = $this->find()
			->where(['ShopSlider.id' => $id])
			->first();

		return $result ? $result->toArray() : [];
	}

	public function getAll(): array
	{
		return $this->find()->toArray();
	}

	public function getAppSlidersCount(): int
	{
		return $this->find()->count();
	}

	public function deleteAppSlider(int $id): bool
	{
		return $this->deleteAll(['ShopSlider.id' => $id], false) > 0;
	}
}
?>
