<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class RepostVideosTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('repost_video');
		$this->setPrimaryKey('id');

		$this->belongsTo('Video', [
			'foreignKey' => 'video_id'
		]);

		$this->belongsTo('User', [
			'foreignKey' => 'user_id'
		]);
	}

	public function getDetails(int $id): ?array
	{
		$result = $this->find()
			->where(['RepostVideo.id' => $id])
			->first();

		return $result ? $result->toArray() : null;
	}

	public function getUserVideoReposts(int $user_id): array
	{
		return $this->find()
			->select(['RepostVideo.video_id'])
			->where(['RepostVideo.user_id' => $user_id])
			->toArray();
	}

	public function getAllRespostedVideos(int $user_id, int $starting_point): array
	{
		return $this->find()
			->contain(['Video'])
			->where([
				'RepostVideo.user_id' => $user_id,
				'Video.id IS NOT' => null
			])
			->limit(constant('APP_RECORDS_PER_PAGE'))
			->offset($starting_point * constant('APP_RECORDS_PER_PAGE'))
			->order(['RepostVideo.id' => 'DESC'])
			->toArray();
	}

	public function countRepost(int $video_id): int
	{
		return $this->find()
			->where(['RepostVideo.video_id' => $video_id])
			->count();
	}

	public function ifExist(array $data): ?array
	{
		$result = $this->find()
			->where([
				'RepostVideo.video_id' => $data['video_id'],
				'RepostVideo.user_id' => $data['user_id']
			])
			->first();

		return $result ? $result->toArray() : null;
	}

	public function getAll(): array
	{
		return $this->find()->toArray();
	}
}
?>
