<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class ReportVideosTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('report_video');
		$this->setPrimaryKey('id');

		$this->belongsTo('User', [
			'foreignKey' => 'user_id'
		]);

		$this->belongsTo('Video', [
			'foreignKey' => 'video_id'
		]);
	}

	public function getDetails(int $id): ?array
	{
		$result = $this->find()
			->where(['ReportVideo.id' => $id])
			->first();

		return $result ? $result->toArray() : null;
	}

	public function getReportsAgainstVideo(int $video_id): ?array
	{
		$result = $this->find()
			->where(['ReportVideo.video_id' => $video_id])
			->first();

		return $result ? $result->toArray() : null;
	}

	public function getAll(): array
	{
		return $this->find()
			->order(['ReportVideo.id' => 'DESC'])
			->toArray();
	}
}
?>
