<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class ReportRoomsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('report_room');
		$this->setPrimaryKey('id');

		$this->belongsTo('User', [
			'foreignKey' => 'user_id'
		]);

		$this->belongsTo('Room', [
			'foreignKey' => 'room_id'
		]);

		$this->belongsTo('ReportReason', [
			'foreignKey' => 'report_reason_id'
		]);
	}

	public function getDetails(int $id): array
	{
		$result = $this->find()
			->where(['ReportRoom.id' => $id])
			->first();

		return $result ? $result->toArray() : [];
	}

	public function ifExist(int $user_id, int $room_id): array
	{
		$result = $this->find()
			->where([
				'ReportRoom.user_id' => $user_id,
				'ReportRoom.room_id' => $room_id
			])
			->first();

		return $result ? $result->toArray() : [];
	}

	public function getAll(): array
	{
		return $this->find()
			->order(['ReportRoom.id' => 'DESC'])
			->toArray();
	}
}
?>
