<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class ReportReasonsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('report_reason');
		$this->setPrimaryKey('id');
	}

	public function getDetails(mixed $id): ?array
	{
		$result = $this->find()
			->where(['ReportReason.id' => $id])
			->first();

		return $result ? $result->toArray() : null;
	}

	public function getAll(): array
	{
		return $this->find()->toArray();
	}

	public function checkDuplicate(mixed $title): int
	{
		return $this->find()
			->where(['ReportReason.title' => $title])
			->count();
	}
}
?>
