<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class ReportProductsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('report_product');
		$this->setPrimaryKey('id');

		$this->belongsTo('User', [
			'foreignKey' => 'user_id'
		]);

		$this->belongsTo('Product', [
			'foreignKey' => 'product_id'
		]);

		$this->belongsTo('ReportReason', [
			'foreignKey' => 'report_reason_id'
		]);
	}

	public function getDetails(int $id): ?array
	{
		$result = $this->find()
			->where(['ReportProduct.id' => $id])
			->first();

		return $result ? $result->toArray() : null;
	}

	public function getReportsAgainstProduct(int $product_id): ?array
	{
		$result = $this->find()
			->where(['ReportProduct.product_id' => $product_id])
			->first();

		return $result ? $result->toArray() : null;
	}

	public function getAll(): array
	{
		return $this->find()
			->order(['ReportProduct.id' => 'DESC'])
			->toArray();
	}
}
?>
