<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class PushNotificationsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('push_notification');
		$this->setPrimaryKey('id');

		$this->belongsTo('User', [
			'foreignKey' => 'id'
		]);
	}

	public function getDetails(int $id): array
	{
		$result = $this->find()
			->where(['PushNotification.id' => $id])
			->first();

		return $result ? $result->toArray() : [];
	}
}
?>
