<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class PurchaseCoinsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('purchase_coin');
		$this->setPrimaryKey('id');

		$this->belongsTo('User', [
			'foreignKey' => 'user_id'
		]);
	}

	public function getDetails(int $id): array
	{
		$result = $this->find()
			->where(['PurchaseCoin.id' => $id])
			->first();

		return $result ? $result->toArray() : [];
	}

	public function getAll(): array
	{
		return $this->find()->toArray();
	}

	public function totalAmountPurchase(int $user_id): array
	{
		$result = $this->find()
			->select([
				'total_amount' => $this->find()->func()->sum('PurchaseCoin.coin')
			])
			->where(['PurchaseCoin.user_id' => $user_id])
			->first();

		return $result ? $result->toArray() : [];
	}
}
?>
