<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class ProductImagesTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('product_image');
		$this->setPrimaryKey('id');

		$this->belongsTo('Product', [
			'foreignKey' => 'product_id'
		]);
	}

	public function getDetails(int $id): array
	{
		$result = $this->find()
			->where(['ProductImage.id' => $id])
			->first();

		return $result ? $result->toArray() : [];
	}

	public function getAll(): array
	{
		return $this->find()
			->order(['ProductImage.id' => 'DESC'])
			->toArray();
	}

	public function getProductImageAgainstProductID(int $product_id): array
	{
		return $this->find()
			->where(['ProductImage.product_id' => $product_id])
			->toArray();
	}
}
?>
