<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class ProductDetailsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('product_detail');
		$this->setPrimaryKey('id');

		$this->belongsTo('Product', [
			'foreignKey' => 'product_id'
		]);
	}

	public function getDetails(int $id): array
	{
		$result = $this->find()
			->where(['ProductDetail.id' => $id])
			->first();

		return $result ? $result->toArray() : [];
	}

	public function getDetailsAgainstMealmeID(string $product_mealme_id): array
	{
		$result = $this->find()
			->where(['ProductDetail.product_mealme_id' => $product_mealme_id])
			->first();

		return $result ? $result->toArray() : [];
	}
}
?>
