<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class ProductAttributeVariationsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('product_attribute_variation');
		$this->setPrimaryKey('id');

		$this->belongsTo('ProductAttribute', [
			'foreignKey' => 'product_attribute_id'
		]);
	}

	public function getDetails(int $id): array
	{
		$result = $this->find()
			->where(['ProductAttributeVariation.id' => $id])
			->first();

		return $result ? $result->toArray() : [];
	}

	public function ifExist(array $data): array
	{
		$result = $this->find()
			->where([
				'ProductAttributeVariation.value' => $data['value'],
				'ProductAttributeVariation.price' => $data['price'],
				'ProductAttributeVariation.product_attribute_id' => $data['product_attribute_id']
			])
			->first();

		return $result ? $result->toArray() : [];
	}

	public function deleteAllVariations(int $product_attribute_id): bool
	{
		return $this->deleteAll(
			['ProductAttributeVariation.product_attribute_id' => $product_attribute_id],
			false
		) > 0;
	}
}
?>
