<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class ProductAttributeCombinationsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('product_attribute_combination');
		$this->setPrimaryKey('id');

		$this->belongsTo('Product', [
			'foreignKey' => 'product_id'
		]);
	}

	public function getDetails(int $id): array
	{
		$result = $this->find()
			->where(['ProductAttributeCombination.id' => $id])
			->first();

		return $result ? $result->toArray() : [];
	}

	public function deleteAllCombinations(int $product_id): void
	{
		$this->deleteAll(
			['ProductAttributeCombination.product_id' => $product_id],
			false
		);
	}
}
?>
