<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class PrivacySettingsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('privacy_setting');
		$this->setPrimaryKey('id');

		$this->belongsTo('User', [
			'foreignKey' => 'id'
		]);
	}

	public function getDetails(int $id): array
	{
		$result = $this->find()
			->where(['PrivacySetting.id' => $id])
			->first();

		return $result ? $result->toArray() : [];
	}
}
?>
