<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class PlaylistsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('playlist');
		$this->setPrimaryKey('id');

		$this->hasMany('PlaylistVideo', [
			'foreignKey' => 'playlist_id',
			'dependent' => true
		]);
	}

	public function getImages(): array
	{
		return $this->find()->toArray();
	}

	public function getDetails(int $id): array|false
	{
		$result = $this->find()
			->where(['Playlist.id' => $id])
			->contain([
				'PlaylistVideo.Video.User.PushNotification',
				'PlaylistVideo.Video.User.PrivacySetting',
				'PlaylistVideo.Video.Sound'
			])
			->first();

		return $result ? $result->toArray() : false;
	}

	public function getUserPlaylist(int $user_id): array
	{
		return $this->find()
			->where(['Playlist.user_id' => $user_id])
			->contain([
				'PlaylistVideo.Video.User.PushNotification',
				'PlaylistVideo.Video.User.PrivacySetting',
				'PlaylistVideo.Video.Sound'
			])
			->toArray();
	}

	public function getUserOnlyPlaylist(int $user_id): array
	{
		return $this->find()
			->where(['Playlist.user_id' => $user_id])
			->toArray();
	}

	public function ifExist(string $name): array|false
	{
		$result = $this->find()
			->where(['Playlist.name' => $name])
			->first();

		return $result ? $result->toArray() : false;
	}

	public function getAll(): array
	{
		return $this->find()->toArray();
	}

	public function getAppSlidersCount(): int
	{
		return $this->find()->count();
	}

	public function deletePlaylist(int $id): bool
	{
		return $this->deleteAll(['Playlist.id' => $id], false) > 0;
	}
}
?>
