<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class PlaylistVideosTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('playlist_video');
		$this->setPrimaryKey('id');

		$this->belongsTo('Video', [
			'foreignKey' => 'video_id'
		]);

		$this->belongsTo('Playlist', [
			'foreignKey' => 'playlist_id'
		]);
	}

	public function getImages(): array
	{
		return $this->find()->toArray();
	}

	public function getDetails(int $id): array
	{
		$result = $this->find()
			->where(['PlaylistVideo.id' => $id])
			->first();

		return $result ? $result->toArray() : [];
	}

	public function getDetailsAgainstVideoID(int $video_id): array
	{
		$result = $this->find()
			->where(['PlaylistVideo.video_id' => $video_id])
			->first();

		return $result ? $result->toArray() : [];
	}

	public function getAll(): array
	{
		return $this->find()->toArray();
	}

	public function getAppSlidersCount(): int
	{
		return $this->find()->count();
	}

	public function deletePlaylist(int $id): bool
	{
		return $this->deleteAll(['Playlist.id' => $id], false) > 0;
	}

	public function deletePlaylistVideo(int $playlist_id): bool
	{
		return $this->deleteAll(['PlaylistVideo.playlist_id' => $playlist_id], false) > 0;
	}
}
?>
