<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class OrderProductsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('order_product');
		$this->setPrimaryKey('id');

		$this->belongsTo('Order', [
			'foreignKey' => 'order_id'
		]);

		$this->belongsTo('Product', [
			'foreignKey' => 'product_id'
		]);
	}

	public function getDetails(int $id): array
	{
		$result = $this->find()
			->where(['OrderProduct.id' => $id])
			->first();

		return $result ? $result->toArray() : [];
	}

	public function countSoldProducts(int $product_id): int
	{
		return $this->find()
			->where(['OrderProduct.product_id' => $product_id])
			->count();
	}

	public function getAll(): array
	{
		return $this->find()
			->contain(['Product'])
			->order(['Product.id' => 'DESC'])
			->toArray();
	}

	public function getProductsAgainstCategory(int $category_id): array
	{
		return $this->find()
			->contain(['Product'])
			->where(['Product.category_id' => $category_id])
			->toArray();
	}
}
?>
