<?php

declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class InterestSectionsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('interest_section');
		$this->setPrimaryKey('id');

		$this->hasMany('Interests', [
			'foreignKey' => 'interest_section_id',
			'dependent' => true
		]);
	}

	public function getDetails(int $id): ?array
	{
		$record = $this->find()
			->where(['InterestSections.id' => $id])
			->contain([
				'Interests' => function ($q) {
					return $q->orderAsc('Interests.order');
				}
			])
			->first();

		return $record ? $record->toArray() : null;
	}

	public function getAllNotAllegens(): array
	{
		return $this->find()
			->where(['InterestSections.title !=' => 'allegens'])
			->contain([
				'Interests' => function ($q) {
					return $q->orderAsc('Interests.order');
				}
			])
			->orderAsc('InterestSections.order')
			->all()
			->toList();
	}

	public function getOnlySection(): array
	{
		return $this->find()
			->orderAsc('InterestSections.order')
			->disableAutoFields()
			->all()
			->toList();
	}

	public function ifExist(string $title): ?array
	{
		$record = $this->find()
			->where(['InterestSections.title' => $title])
			->first();

		return $record ? $record->toArray() : null;
	}
}
