<?php

declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class HashtagsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('hashtag');
		$this->setPrimaryKey('id');
	}

	public function getDetails(int $id): array
	{
		$record = $this->find()
			->where(['id' => $id])
			->first();

		return $record ? $record->toArray() : [];
	}

	public function ifExist(string $name): array
	{
		$record = $this->find()
			->where(['name' => $name])
			->first();

		return $record ? $record->toArray() : [];
	}

	public function getSearchResults(string $keyword, int $starting_point): array
	{
		return $this->find()
			->where(['name LIKE' => "$keyword%"])
			->limit(10)
			->offset($starting_point * 10)
			->toArray();
	}
}
