<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class HashtagFavouritesTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);
		$this->setTable('hashtag_favourite');
		$this->belongsTo('Hashtag', [
			'foreignKey' => 'hashtag_id',
			'className' => 'Hashtag',
		]);
		$this->belongsTo('User', [
			'foreignKey' => 'user_id',
			'className' => 'User',
			'fields' => USER_FIELDS,
		]);
	}

	public function getDetails(int $id): array
	{
		$entity = $this->find()
			->where(['HashtagFavourite.id' => $id])
			->first();

		return $entity ? $entity->toArray() : [];
	}

	public function getUserFavouriteHashtags(int $user_id, int $starting_point): array
	{
		return $this->find()
			->contain(['Hashtag', 'User'])
			->where(['HashtagFavourite.user_id' => $user_id])
			->limit(10)
			->offset($starting_point * 10)
			->all()
			->toArray();
	}

	public function ifExist(array $data): array
	{
		$entity = $this->find()
			->where([
				'HashtagFavourite.hashtag_id' => $data['hashtag_id'],
				'HashtagFavourite.user_id'    => $data['user_id'],
			])
			->first();

		return $entity ? $entity->toArray() : [];
	}

	public function getAll(): array
	{
		return $this->find()
			->all()
			->toArray();
	}
}
