<?php

declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class EmailVerificationsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('email_verification');
		$this->setPrimaryKey('id');
	}

	public function verifyCode(string $email, string $code): ?array
	{
		$record = $this->find()
			->where([
				'email' => $email,
				'code' => $code
			])
			->first();

		return $record ? $record->toArray() : null;
	}

	public function getDetails(int $id): ?array
	{
		$record = $this->find()
			->where(['id' => $id])
			->first();

		return $record ? $record->toArray() : null;
	}
}
