<?php

declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class DocumentsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('document');
		$this->setPrimaryKey('id');

		$this->belongsTo('Users', [
			'foreignKey' => 'user_id',
			'joinType' => 'INNER',
		]);
	}

	public function getDetails(int $id): array
	{
		$record = $this->find()
			->where(['id' => $id])
			->first();

		return $record ? $record->toArray() : [];
	}

	public function checkDocumentExistAgainstUserID(int $user_id): array
	{
		return $this->find()
			->where(['user_id' => $user_id])
			->all()
			->toList();
	}

	public function getDocument(int $user_id): array
	{
		return $this->find()
			->where(['user_id' => $user_id])
			->disableHydration()
			->all()
			->toList();
	}

	public function getDocumentAgainstType(int $user_id, string $type): array
	{
		$record = $this->find()
			->where([
				'user_id' => $user_id,
				'type' => $type,
				'status IN' => [0, 1]
			])
			->disableHydration()
			->first();

		return $record ? $record : [];
	}

	public function getAll(): array
	{
		return $this->find()->all()->toList();
	}
}
