<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class CartSlidersTable extends Table
{
	protected function initialize(array $config): void
	{
		parent::initialize($config);
		$this->setTable('cart_slider');
		$this->setPrimaryKey('id');
	}

	public function getImages(): array
	{
		return $this
			->find()
			->all()
			->toArray();
	}

	public function getDetails(int $id): array
	{
		$entity = $this
			->find()
			->where(['id' => $id])
			->first();

		return $entity ? $entity->toArray() : [];
	}

	public function getAll(): array
	{
		return $this
			->find()
			->all()
			->toArray();
	}

	public function getAppSlidersCount(): int
	{
		return $this
			->find()
			->count();
	}

	public function deleteAppSlider(int $id): bool
	{
		return (bool)$this->deleteAll(['id' => $id], false);
	}
}
