<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class BlockUsersTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);
		$this->setTable('block_user');
		$this->belongsTo('BlockedUser', [
			'className' => 'App\Model\Table\UsersTable',
			'foreignKey' => 'block_user_id',
		]);
	}

	public function getDetails(int $id): array
	{
		$entity = $this->find()
			->where(['BlockUser.id' => $id])
			->first();
		return $entity ? $entity->toArray() : [];
	}

	public function getBlockUsers(int $user_id): array
	{
		return $this->find()
			->where(['BlockUser.user_id' => $user_id])
			->all()
			->toArray();
	}

	public function ifAlreadyBlocked(array $data): array
	{
		$entity = $this->find()
			->where([
				'BlockUser.user_id' => $data['user_id'],
				'BlockUser.block_user_id' => $data['block_user_id'],
			])
			->first();
		return $entity ? $entity->toArray() : [];
	}

	public function ifBlocked(int $user_id, int $block_user_id): array
	{
		$entity = $this->find()
			->where([
				'BlockUser.user_id' => $user_id,
				'BlockUser.block_user_id' => $block_user_id,
			])
			->first();
		return $entity ? $entity->toArray() : [];
	}
}
