<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class AudienceLocationTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);
		$this->setTable('audience_location');
		$this->belongsTo('Audience', [
			'className' => 'Audience',
			'foreignKey' => 'audience_id',
		]);
		$this->belongsTo('Country', [
			'className' => 'Country',
			'foreignKey' => 'country_id',
		]);
		$this->belongsTo('State', [
			'className' => 'State',
			'foreignKey' => 'state_id',
		]);
		$this->belongsTo('City', [
			'className' => 'City',
			'foreignKey' => 'city_id',
		]);
	}

	public function getDetails(int $id): array
	{
		$row = $this->find()
			->where(['AudienceLocation.id' => $id])
			->disableHydration()
			->first();
		return $row ?: [];
	}

	public function getCountriesAgainstAudience(int $audience_id): array
	{
		return $this->find()
			->where(['AudienceLocation.audience_id' => $audience_id])
			->disableHydration()
			->toArray();
	}
}
