<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;
use Cake\Datasource\ResultSetInterface;

class AppSlidersTable extends Table
{
	public function getImages(): ResultSetInterface
	{
		return $this->find()->all();
	}

	public function getDetails(int $id): array
	{
		$record = $this->find()
			->where(['AppSliders.id' => $id])
			->first();

		return $record ? $record->toArray() : [];
	}

	public function getAll(): ResultSetInterface
	{
		return $this->find()->all();
	}

	public function getAppSlidersCount(): int
	{
		return $this->find()->count();
	}

	public function deleteAppSlider(int $id): bool
	{
		return $this->deleteAll(['AppSliders.id' => $id]) > 0;
	}
}
