<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

class StripePlan extends Entity
{
	protected string $path = '/plans';

	protected array $_schema = [
		'id' => ['type' => 'string', 'length' => 45],
		'amount' => ['type' => 'integer'],
		'currency' => ['type' => 'string', 'length' => 3],
		'interval' => ['type' => 'string', 'length' => 5],
		'name' => ['type' => 'string'],
		'trial_period_days' => ['type' => 'integer']
	];

	protected function _beforeSave($event, $entity, $options)
	{
		$entity->set('id', null);
		return true;
	}
}
