<?php

declare(strict_types=1);

use Cake\TestSuite\TestCase;
use Cake\Datasource\ConnectionManager;
use Cake\Http\Client;

class StripeCustomerTest extends TestCase
{
    protected StripeCustomer $Model;
    protected mixed $Source;

    public function setUp(): void
    {
        parent::setUp();
        $this->Model = new StripeCustomer();
        $this->Model->setDataSource('stripe_test');
        $sources = ConnectionManager::configured();
        $this->skipIf(!in_array('stripe_test', $sources), '`stripe_test` db config not found');
        $this->Source = $this->Model->getDataSource('stripe_test');
        $this->Source->Http = $this->createMock(Client::class);
    }

    public function tearDown(): void
    {
        parent::tearDown();
        unset($this->Model);
    }

    public function testCreate(): void
    {
        $this->Source->Http->method('post')
            ->willReturn(new \Cake\Http\Client\Response([
                'status' => 200,
                'body' => json_encode(['id' => '1234']),
            ]));

        $this->Model->create();
        $result = $this->Model->save([
            'StripeCustomer' => [
                'id' => '1234',
                'number' => '4242424242424242',
                'exp_month' => '11',
                'exp_year' => date('Y', strtotime('next year')),
                'cvc' => '123',
                'email' => 'jeremy@42pixels.com',
                'description' => 'Jeremy Harris',
            ],
        ]);

        $this->assertNotFalse($result);
    }

    public function testUpdate(): void
    {
        $this->Source->Http->method('post')
            ->willReturn(new \Cake\Http\Client\Response([
                'status' => 200,
                'body' => json_encode(['id' => '1234']),
            ]));

        $this->Model->id = '1234';
        $result = $this->Model->save([
            'StripeCustomer' => [
                'description' => 'Not Jeremy Harris',
            ],
        ]);

        $this->assertNotFalse($result);
    }

    public function testDelete(): void
    {
        $this->Source->Http->method('delete')
            ->willReturn(new \Cake\Http\Client\Response([
                'status' => 200,
                'body' => json_encode(['id' => '1234']),
            ]));

        $this->Model->delete('1234');
    }
}