<?php

declare(strict_types=1);

use Cake\TestSuite\TestCase;
use Cake\Datasource\ConnectionManager;
use Stripe\Model\StripeAppModel;

class StripeAppTest extends TestCase
{
    protected StripeAppModel $Model;

    public function setUp(): void
    {
        parent::setUp();
        $this->Model = new StripeAppModel();
        $this->Model->setDataSource('stripe_test');
        $sources = ConnectionManager::configured();
        $this->skipIf(!in_array('stripe_test', $sources, true), '`stripe_test` db config not found');
    }

    public function tearDown(): void
    {
        parent::tearDown();
        unset($this->Model);
    }

    public function testGetStripeError(): void
    {
        $ds = ConnectionManager::get('stripe_test');
        $ds->lastError = 'Some error! Ack something broke!';

        $this->assertSame($this->Model->getStripeError(), $ds->lastError);
    }
}