# Fork of CakePHP 2 with PHP 8 Support

~~For the original README content, check the original repository: [CakePHP 2.x](https://github.com/cakephp/cakephp/tree/2.x)~~

Unfortunately, the `2.x` branch in the original repository has been removed.

## 📢 Breaking Changes Incoming

The `strftime()` function is widely used in the framework codebase. We plan to replace it with `IntlDateFormatter::format()`, which requires the `Intl` PHP extension. CakePHP 2 originally did not rely on this extension, so this will be a **breaking change**.

We aim to roll this out in **May 2024**. If you have any concerns, discuss them here: [Issue #65](https://github.com/kamilwylegala/cakephp2-php8/issues/65).

---

## 🤔 Why Was This Fork Created?

CakePHP 2 stopped receiving updates at the end of 2019. For some users, migrating to newer CakePHP versions is expensive or impractical. This fork ensures compatibility with **PHP 8** while keeping the ORM and other core functionalities intact.

---

## ⛔ Why You Should NOT Use This Fork

- This fork **only provides PHP 8 compatibility** and **will not** receive new features.
- If you are still using **PHP 5.6 or 7.0**, do **not** use this fork. Instead:
  - Migrate to PHP 7.4 and keep using the original CakePHP 2.x.
  - Once stable on PHP 7.4, switch to PHP 8 and use this fork.

---

## ✅ When Should You Use This Fork?

You should **only** use this fork if your application is already running on **PHP 7.4**. 

### **Migration Steps**
If you're migrating to PHP 8, consider these steps:

1. **Decouple your tests** from `CakeTestCase` and other utilities that rely on outdated PHPUnit versions.
2. **Upgrade PHPUnit** to the latest version compatible with your PHP version.
3. **Gradually upgrade to PHP 7.4** (CakePHP 2 works fine on 7.0–7.4).
4. **Upgrade to PHP 8 and switch to this fork.**

---

## ⚠️ Before Using This Fork

- ✅ **Tests have been migrated** to **PHPUnit 9**.
- ✅ **GitHub Actions now run tests** on PHP 8.0 and 8.1.
- **You must rely on your application's test suite** to verify compatibility.
- If you encounter framework-related issues, please report them via an issue or pull request.

---

## 📦 Installation

This repository is **not** available on Packagist. You must manually update your project's `composer.json`:

```json
{
    "require": {
        "cakephp/cakephp": "dev-master as 2.10.24"
    },
    "repositories": [
        {
            "type": "vcs",
            "url": "https://github.com/kamilwylegala/cakephp2-php8"
        }
    ]
}