# How to Contribute

CakePHP welcomes contributions! You can help in various ways:
* Report a [GitHub issue](https://github.com/cakephp/cakephp/issues) if you find a bug.
* Write test cases for open issues.
* Submit patches for bug fixes and feature requests (preferably with tests).
* Improve the [documentation](https://github.com/cakephp/docs).

## Code of Conduct

Help us maintain an open and inclusive community by following our [Code of Conduct](https://github.com/cakephp/code-of-conduct/blob/master/CODE_OF_CONDUCT.md).

## Getting Started

1. Ensure you have a [GitHub account](https://github.com/signup/free).
2. Check if an [issue](https://github.com/cakephp/cakephp/issues) already exists before submitting one.
   * Clearly describe the issue with steps to reproduce.
   * Mention the earliest version affected.
3. Fork the repository on GitHub.

## Making Changes

1. **Create a feature branch**:
   * Typically based on the `master` branch.
   * Use `git checkout -b feature/my-update master` to create a new branch.
2. **Write meaningful commits**:
   * Keep commits atomic and logical.
   * Use descriptive messages and reference issue numbers where applicable.
3. **Follow PHP 8 best practices**:
   * Type hinting (`public function foo(int $bar): string {}`)
   * Nullable types (`?string $name = null`)
   * Strict typing (`declare(strict_types=1);` at the top of files)
4. **Check your code**:
   * Run `git diff --check` to avoid whitespace errors.
   * Ensure your code follows [CakePHP coding standards](https://book.cakephp.org/4/en/contributing/cakephp-coding-conventions.html).

## Branch Guidelines

* **Bugfixes**: Branch off from `master`.
* **New Features**: Branch off from the next minor release branch.
* **Breaking Changes**: Branch off from the next major release branch.

## Submitting Changes

1. Push your changes to your fork.
2. Submit a **pull request (PR)** to the CakePHP repository with the correct target branch.
3. Ensure your PR includes:
   * A clear title and description.
   * Relevant tests for the changes.
   * A reference to related issues if applicable.

## Running Tests

CakePHP uses PHPUnit for testing. To run tests locally:

```sh
vendor/bin/phpunit
```

To check coding standards:

```sh
vendor/bin/phpcs -p --extensions=php --standard=CakePHP src/
```

Check the [cakephp-codesniffer](https://github.com/cakephp/cakephp-codesniffer) repository for setup details.

## Reporting Security Issues

If you've found a security issue, please **do not open a public issue**. Instead, email security@cakephp.org. See the [CakePHP Security Issue Process](https://book.cakephp.org/4/en/contributing/tickets.html#reporting-security-issues).

## Additional Resources

* [CakePHP Coding Standards](https://book.cakephp.org/4/en/contributing/cakephp-coding-conventions.html)
* [Existing Issues](https://github.com/cakephp/cakephp/issues)
* [Development Roadmap](https://github.com/cakephp/cakephp/wiki#roadmaps)
* [GitHub Docs](https://help.github.com/)
* [CakePHP Community on Stack Overflow](https://stackoverflow.com/tags/cakephp)
* `#cakephp` IRC channel on Libera.Chat