<?php
use Cake\Core\Configure;
use Cake\Error\Debugger;
use Cake\Cache\Cache;
use Cake\Datasource\ConnectionManager;
use Cake\Core\Plugin;
?>
<h2><?= __('Release Notes for CakePHP {0}.', Configure::version()) ?></h2>
<p><?= $this->Html->link(__('Read the changelog'), 'https://book.cakephp.org/' . Configure::version() . '/en/appendices/1-changelogs.html', ['target' => '_blank']) ?></p>
<?php if (Configure::read('debug')) Debugger::checkSecurityKeys(); ?>
<?php if (file_exists(WWW_ROOT . 'css' . DS . 'cake.generic.css')): ?>
<p id="url-rewriting-warning" style="background-color:#e32;color:#fff;">
    <?= __('URL rewriting is not properly configured on your server.') ?>
    <a target="_blank" href="https://book.cakephp.org/4/en/installation.html#url-rewriting" style="color:#fff;"><?= __('Help me configure it') ?></a>
    <a target="_blank" href="https://book.cakephp.org/4/en/development/configuration.html#core-configuration" style="color:#fff;"><?= __("I don't / can't use URL rewriting") ?></a>
</p>
<?php endif ?>
<p>
    <?php if (version_compare(PHP_VERSION, '7.2.0', '>=')): ?>
        <span class="notice success"><?= __('Your version of PHP is {0} or higher.', PHP_VERSION) ?></span>
    <?php else: ?>
        <span class="notice"><?= __('Your version of PHP is too low. You need PHP 7.2.0 or higher to use CakePHP {0}.', Configure::version()) ?></span>
    <?php endif ?>
</p>
<p>
    <?php if (is_writable(TMP)): ?>
        <span class="notice success"><?= __('Your tmp directory is writable.') ?></span>
    <?php else: ?>
        <span class="notice"><?= __('Your tmp directory is NOT writable.') ?></span>
    <?php endif ?>
</p>
<p>
    <?php $cacheConfig = Cache::getConfig('default'); ?>
    <?php if ($cacheConfig): ?>
        <span class="notice success"><?= __('The {0} is being used for core caching. To change the config edit {1}', '<em>' . $cacheConfig['className'] . '</em>', 'config/app.php') ?></span>
    <?php else: ?>
        <span class="notice"><?= __('Your cache is NOT working. Please check the settings in {0}', 'config/app.php') ?></span>
    <?php endif ?>
</p>
<p>
    <?php if (file_exists(CONFIG . 'app.php')): ?>
        <span class="notice success"><?= __('Your database configuration file is present.') ?></span>
    <?php else: ?>
        <span class="notice"><?= __('Your database configuration file is NOT present.') ?><br/><?= __('Rename {0} to {1}', 'config/app.php.default', 'config/app.php') ?></span>
    <?php endif ?>
</p>
<?php if (file_exists(CONFIG . 'app.php')): ?>
    <?php
    try {
        $connection = ConnectionManager::get('default');
        $connected = $connection->connect();
    } catch (\Exception $e) {
        $connected = false;
        $errorMsg = $e->getMessage();
    }
    ?>
    <p>
        <?php if ($connected): ?>
            <span class="notice success"><?= __('CakePHP is able to connect to the database.') ?></span>
        <?php else: ?>
            <span class="notice"><?= __('CakePHP is NOT able to connect to the database.') ?><br/><br/><?= h($errorMsg) ?></span>
        <?php endif ?>
    </p>
<?php endif ?>
<p>
    <?php if (Plugin::isLoaded('DebugKit')): ?>
        <span class="notice success"><?= __('DebugKit plugin is present') ?></span>
    <?php else: ?>
        <span class="notice"><?= __('DebugKit is not installed. It will help you inspect and debug different aspects of your application.') ?><br/><?= __('You can install it with {0}', '<code>composer require --dev cakephp/debug_kit</code>') ?></span>
    <?php endif ?>
</p>
<h3><?= __('Editing this Page') ?></h3>
<p>
    <?= __('To change the content of this page, edit: {0}. To change its layout, edit: {1}. You can also add some CSS styles for your pages at: {2}', 'templates/Pages/home.php', 'templates/layout/default.php', 'webroot/css/app.css') ?>
</p>
<h3><?= __('Getting Started') ?></h3>
<p><?= $this->Html->link(sprintf('<strong>%s</strong> %s', __('New'), __('CakePHP 4.x Docs')), 'https://book.cakephp.org/4/en/', ['target' => '_blank', 'escape' => false]) ?></p>
<p><?= $this->Html->link(__('The 15 min Blog Tutorial'), 'https://book.cakephp.org/4/en/tutorials-and-examples/blog/blog.html', ['target' => '_blank']) ?></p>
<h3><?= __('Official Plugins') ?></h3>
<ul>
    <li><?= $this->Html->link('DebugKit', 'https://github.com/cakephp/debug_kit') ?>: <?= __('provides a debugging toolbar and enhanced debugging tools for CakePHP applications.') ?></li>
    <li><?= $this->Html->link('Bake', 'https://github.com/cakephp/bake') ?>: <?= __('provides code generation for controllers, models, templates and more.') ?></li>
</ul>
<h3><?= __('More about CakePHP') ?></h3>
<p><?= __('CakePHP is a rapid development framework for PHP which uses commonly known design patterns like Active Record, Association Data Mapping, Front Controller and MVC.') ?></p>
<p><?= __('Our primary goal is to provide a structured framework that enables PHP users at all levels to rapidly develop robust web applications, without any loss to flexibility.') ?></p>
<ul>
    <li><a href="https://cakephp.org">CakePHP<ul><li><?= __('The Rapid Development Framework') ?></li></ul></a></li>
    <li><a href="https://book.cakephp.org"><?= __('CakePHP Documentation') ?><ul><li><?= __('Your Rapid Development Cookbook') ?></li></ul></a></li>
    <li><a href="https://api.cakephp.org"><?= __('CakePHP API') ?><ul><li><?= __('Quick API Reference') ?></li></ul></a></li>
    <li><a href="https://bakery.cakephp.org"><?= __('The Bakery') ?><ul><li><?= __('Everything CakePHP') ?></li></ul></a></li>
    <li><a href="https://plugins.cakephp.org"><?= __('CakePHP Plugins') ?><ul><li><?= __('A comprehensive list of all CakePHP plugins created by the community') ?></li></ul></a></li>
    <li><a href="https://community.cakephp.org"><?= __('CakePHP Community Center') ?><ul><li><?= __('Everything related to the CakePHP community in one place') ?></li></ul></a></li>
    <li><a href="https://github.com/cakephp/"><?= __('CakePHP Code') ?><ul><li><?= __('Find the CakePHP code on GitHub and contribute to the framework') ?></li></ul></a></li>
    <li><a href="https://github.com/cakephp/cakephp/issues"><?= __('CakePHP Issues') ?><ul><li><?= __('CakePHP Issues') ?></li></ul></a></li>
    <li><a href="https://github.com/cakephp/cakephp/wiki#roadmaps"><?= __('CakePHP Roadmaps') ?><ul><li><?= __('CakePHP Roadmaps') ?></li></ul></a></li>
    <li><a href="https://training.cakephp.org"><?= __('Training') ?><ul><li><?= __('Join a live session and get skilled with the framework') ?></li></ul></a></li>
    <li><a href="https://cakefest.org"><?= __('CakeFest') ?><ul><li><?= __('Don\'t miss our annual CakePHP conference') ?></li></ul></a></li>
    <li><a href="https://cakefoundation.org"><?= __('Cake Software Foundation') ?><ul><li><?= __('Promoting development related to CakePHP') ?></li></ul></a></li>
</ul>