<?php

declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;
use Cake\ORM\Query;
use Cake\Datasource\EntityInterface;
use Cake\Datasource\ResultSetInterface;
use Cake\ORM\TableRegistry;

class AudiencesTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('audience');
		$this->setPrimaryKey('id');

		$this->belongsTo('Users', [
			'foreignKey' => 'user_id',
			'className' => 'App\Model\Table\UsersTable',
		]);
	}

	public function getDetails(int $id): array
	{
		$audience = $this->find()
			->where(['Audience.id' => $id])
			->first();

		return $audience ? $audience->toArray() : [];
	}

	public function getUserAudiences(int $user_id): array
	{
		$audiences = $this->find()
			->contain(['Users'])
			->where(['Audience.user_id' => $user_id])
			->all();

		return $audiences->toArray();
	}
}
