<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class VerificationRequestsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('verification_request');
		$this->setPrimaryKey('id');

		$this->belongsTo('Users', [
			'foreignKey' => 'user_id',
		]);
	}

	public function getDetails(int $id): ?array
	{
		return $this->find()
			->where(['VerificationRequests.id' => $id])
			->enableHydration(false)
			->first();
	}

	public function getVerificationDetailsAgainstUserID(int $user_id): ?array
	{
		return $this->find()
			->where(['VerificationRequests.user_id' => $user_id])
			->enableHydration(false)
			->first();
	}

	public function ifRequestAlreadySubmitted(int $user_id): ?array
	{
		return $this->find()
			->where([
				'VerificationRequests.user_id' => $user_id,
				'VerificationRequests.verified !=' => 2
			])
			->enableHydration(false)
			->first();
	}

	public function getAll(): array
	{
		return $this->find()
			->order(['VerificationRequests.id' => 'DESC'])
			->enableHydration(false)
			->all()
			->toList();
	}
}
