<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class UserInterestsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('user_interest');
		$this->setPrimaryKey('id');

		$this->belongsTo('Interests', [
			'foreignKey' => 'interest_id',
		]);

		$this->belongsTo('Users', [
			'foreignKey' => 'user_id',
		]);
	}

	public function getDetails(int $id): ?array
	{
		return $this->find()
			->where(['UserInterests.id' => $id])
			->enableHydration(false)
			->first();
	}

	public function getAll(): array
	{
		return $this->find()
			->contain([
				'Interests' => function ($q) {
					return $q->orderAsc('UserInterests.order');
				}
			])
			->orderAsc('Interests.interest_section_id') // Assuming 'InterestSection' is a related field
			->enableHydration(false)
			->all()
			->toList();
	}

	public function ifExist(int $user_id, int $interest_id): ?array
	{
		return $this->find()
			->where([
				'UserInterests.user_id' => $user_id,
				'UserInterests.interest_id' => $interest_id
			])
			->enableHydration(false)
			->first();
	}

	public function getAllAgainstUser(int $user_id): array
	{
		return $this->find()
			->where(['UserInterests.user_id' => $user_id])
			->contain(['Interests'])
			->enableHydration(false)
			->all()
			->toList();
	}

	public function deleteAllInterests(int $user_id): bool
	{
		return $this->deleteAll(
			['UserInterests.user_id' => $user_id]
		) > 0;
	}
}
