<?php

declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class PhoneNoVerificationsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('phone_no_verification');
		$this->setPrimaryKey('id');
	}

	public function verifyCode(string $phone_no, string $code): int
	{
		return $this->find()
			->where([
				'PhoneNoVerification.phone_no' => $phone_no,
				'PhoneNoVerification.code' => $code
			])
			->count();
	}
}
