<?php
declare(strict_types=1);

namespace App;

use Cake\Core\Configure;
use Cake\Core\ContainerInterface;
use Cake\Http\BaseApplication;
use Cake\Http\MiddlewareQueue;
use Cake\Routing\Middleware\RoutingMiddleware;
use Cake\Error\Middleware\ErrorHandlerMiddleware;

class Application extends BaseApplication
{
    public function __construct()
    {
        parent::__construct(dirname(__DIR__) . '/config'); // ✅ Use correct config path
    }

    public function bootstrap(): void
    {
        parent::bootstrap();
        // Load other plugins or bootstrap code here
    }

    public function middleware(MiddlewareQueue $middlewareQueue): MiddlewareQueue
    {
        $middlewareQueue
            ->add(new ErrorHandlerMiddleware([])) // ✅ Use default config
            ->add(new RoutingMiddleware($this));
    
        return $middlewareQueue;
    }

    public function services(ContainerInterface $container): void
    {
        // Register your application services here if needed
    }
}